<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Mail;

class MarketingController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        return view('admin.marketing.index');
    }

    public function email(Request $request)
    {
        $request->validate([
            'target' => 'required|in:all,active,inactive,expired',
            'subject' => 'required|string',
            'message' => 'required|string'
        ]);

        $query = User::query();

        switch ($request->target) {
            case 'active':
                $query->whereHas('subscription', function($q) {
                    $q->where('status', 'active');
                });
                break;
            case 'inactive':
                $query->whereDoesntHave('subscription');
                break;
            case 'expired':
                $query->whereHas('subscription', function($q) {
                    $q->where('status', 'expired');
                });
                break;
        }

        $users = $query->get();

        foreach ($users as $user) {
            // Queue email job
            // Mail::to($user->email)->queue(new MarketingEmail($request->subject, $request->message));
        }

        return redirect()->route('admin.marketing.index')
            ->with('success', __('campaign_sent_to', ['count' => $users->count()]));
    }

    public function notify(Request $request)
    {
        $request->validate([
            'target' => 'required|in:all,specific',
            'message' => 'required|string'
        ]);

        if ($request->target == 'specific' && $request->user_id) {
            $users = User::where('id', $request->user_id)->get();
        } else {
            $users = User::all();
        }

        foreach ($users as $user) {
            \App\Models\Notification::create([
                'uid' => $user->id,
                'message' => $request->message,
                'read' => 0
            ]);
        }

        return redirect()->route('admin.marketing.index')
            ->with('success', __('notification_sent'));
    }

    public function mailer(Request $request)
    {
        $fields = ['mail_driver', 'mail_host', 'mail_port', 'mail_username', 
                   'mail_password', 'mail_encryption', 'mail_from_address', 'mail_from_name'];

        foreach ($fields as $field) {
            if ($request->has($field)) {
                \App\Models\Setting::updateOrCreate(
                    ['key' => $field],
                    ['value' => $request->input($field)]
                );
            }
        }

        return redirect()->route('admin.marketing.index')->with('success', __('mailer_settings_saved'));
    }
}
