<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payout;

class PayoutController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        $payouts = Payout::with('user')
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        $stats = [
            'pending' => Payout::where('status', 'pending')->count(),
            'approved' => Payout::where('status', 'approved')->count(),
            'rejected' => Payout::where('status', 'rejected')->count()
        ];

        return view('admin.payouts.index', compact('payouts', 'stats'));
    }

    public function approve($id)
    {
        $payout = Payout::findOrFail($id);
        $payout->update(['status' => 'approved']);

        // Send email notification
        // Mail::to($payout->user->email)->send(new PayoutApproved($payout));

        return redirect()->route('admin.payouts.index')->with('success', __('payout_approved'));
    }

    public function reject(Request $request, $id)
    {
        $payout = Payout::findOrFail($id);
        $payout->update(['status' => 'rejected', 'notes' => $request->reason]);

        // Refund credits to user
        $payout->user->increment('credits', $payout->amount);

        // Send email notification
        // Mail::to($payout->user->email)->send(new PayoutRejected($payout, $request->reason));

        return redirect()->route('admin.payouts.index')->with('success', __('payout_rejected'));
    }
}
