<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Role;

class RoleController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        $roles = Role::withCount('users')->get();
        return view('admin.roles.index', compact('roles'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        Role::create([
            'name' => $request->name,
            'permissions' => is_array($request->permissions) ? implode(',', $request->permissions) : ''
        ]);

        return redirect()->route('admin.roles.index')->with('success', __('role_created'));
    }

    public function update(Request $request, $id)
    {
        $role = Role::findOrFail($id);

        if ($role->id == 1) {
            return back()->with('error', __('cannot_edit_default_role'));
        }

        $role->update([
            'name' => $request->name,
            'permissions' => is_array($request->permissions) ? implode(',', $request->permissions) : ''
        ]);

        return redirect()->route('admin.roles.index')->with('success', __('role_updated'));
    }

    public function destroy($id)
    {
        $role = Role::findOrFail($id);

        if ($role->id == 1) {
            return back()->with('error', __('cannot_delete_default_role'));
        }

        $role->delete();
        return redirect()->route('admin.roles.index')->with('success', __('role_deleted'));
    }
}
