<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Action;

class ActionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $actions = Action::where('uid', auth()->id())->orderBy('created_at', 'desc')->get();
        return view('dashboard.tools.actions', compact('actions'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|string',
            'trigger_type' => 'required|string',
            'trigger_value' => 'required|string',
            'response' => 'required|string'
        ]);

        Action::create([
            'uid' => auth()->id(),
            'name' => $request->name,
            'type' => $request->type,
            'source' => $request->source ?? 'all',
            'trigger_type' => $request->trigger_type,
            'trigger_value' => $request->trigger_value,
            'response' => $request->response,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('dashboard.tools.actions')->with('success', __('action_created'));
    }

    public function update(Request $request, $id)
    {
        $action = Action::where('uid', auth()->id())->findOrFail($id);

        $action->update([
            'name' => $request->name,
            'type' => $request->type,
            'source' => $request->source ?? 'all',
            'trigger_type' => $request->trigger_type,
            'trigger_value' => $request->trigger_value,
            'response' => $request->response,
            'status' => $request->has('status') ? 1 : 0
        ]);

        return redirect()->route('dashboard.tools.actions')->with('success', __('action_updated'));
    }

    public function destroy($id)
    {
        Action::where('uid', auth()->id())->findOrFail($id)->delete();
        return redirect()->route('dashboard.tools.actions')->with('success', __('action_deleted'));
    }

    public function toggle($id)
    {
        $action = Action::where('uid', auth()->id())->findOrFail($id);
        $action->update(['status' => $action->status ? 0 : 1]);

        return response()->json(['success' => true, 'status' => $action->status]);
    }
}
