<?php

namespace App\Http\Controllers\Dashboard\Ai;

use App\Http\Controllers\Controller;
use App\Models\AiPlugin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AiPluginController extends Controller
{
    public function index(Request $request)
    {
        $plugins = AiPlugin::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.ai.plugins', compact('plugins'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'schema' => 'required|string',
            'endpoint' => 'required|url',
        ]);

        AiPlugin::create([
            'uid' => Auth::id(),
            'name' => $request->name,
            'schema' => $request->schema,
            'endpoint' => $request->endpoint,
        ]);

        return back()->with('success', __('messages.ai_plugin_created'));
    }

    public function update(Request $request, AiPlugin $aiPlugin)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'schema' => 'required|string',
            'endpoint' => 'required|url',
        ]);
        
        $aiPlugin->update($request->only(['name', 'schema', 'endpoint']));
        return back()->with('success', __('messages.ai_plugin_updated'));
    }

    public function destroy(AiPlugin $aiPlugin)
    {
        $aiPlugin->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
