<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Flow;
use App\Models\FlowStep;

class FlowController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $flows = Flow::where('uid', auth()->id())->orderBy('created_at', 'desc')->get();
        return view('dashboard.tools.flows', compact('flows'));
    }

    public function create()
    {
        return view('flow.index', ['flow' => null]);
    }

    public function edit($id)
    {
        $flow = Flow::where('uid', auth()->id())->findOrFail($id);
        return view('flow.index', compact('flow'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'nodes' => 'required|array',
        ]);

        $flow = Flow::create([
            'uid' => auth()->id(),
            'name' => $request->name,
            'data' => json_encode($request->nodes),
            'connections' => json_encode($request->connections ?? []),
            'status' => 1
        ]);

        return response()->json(['success' => true, 'flow_id' => $flow->id]);
    }

    public function update(Request $request, $id)
    {
        $flow = Flow::where('uid', auth()->id())->findOrFail($id);

        $request->validate([
            'name' => 'required|string|max:255',
            'nodes' => 'required|array',
        ]);

        $flow->update([
            'name' => $request->name,
            'data' => json_encode($request->nodes),
            'connections' => json_encode($request->connections ?? [])
        ]);

        return response()->json(['success' => true]);
    }

    public function destroy($id)
    {
        $flow = Flow::where('uid', auth()->id())->findOrFail($id);
        $flow->delete();

        return response()->json(['success' => true]);
    }

    public function toggle($id)
    {
        $flow = Flow::where('uid', auth()->id())->findOrFail($id);
        $flow->update(['status' => $flow->status ? 0 : 1]);

        return response()->json(['success' => true, 'status' => $flow->status]);
    }
}
