<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $user = auth()->user();
        $languages = \App\Models\Language::all();
        return view('dashboard.profile', compact('user', 'languages'));
    }

    public function update(Request $request)
    {
        $user = auth()->user();

        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email,' . $user->id
        ]);

        $data = [
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'language' => $request->language,
            'timezone' => $request->timezone,
            'alertsound' => $request->has('alertsound') ? 1 : 0
        ];

        // Handle password change
        if ($request->filled('new_password')) {
            if (!\Hash::check($request->current_password, $user->password)) {
                return back()->with('error', __('current_password_incorrect'));
            }
            $data['password'] = \Hash::make($request->new_password);
        }

        // Handle avatar upload
        if ($request->hasFile('avatar')) {
            $path = $request->file('avatar')->store('public/avatars');
            $data['avatar'] = str_replace('public/', 'storage/', $path);
        }

        $user->update($data);

        return back()->with('success', __('profile_updated'));
    }
}
