<?php

namespace App\Http\Controllers\Dashboard\Sms;

use App\Http\Controllers\Controller;
use App\Models\Sent;
use App\Models\Device;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class QueueController extends Controller
{
    public function index(Request $request)
    {
        $query = Sent::where('uid', Auth::id())->where('status', 1); // Pending
        
        $messages = $query->orderBy('create_date', 'desc')->paginate(25);
        return view('dashboard.sms.queue', compact('messages'));
    }

    public function clear()
    {
        Sent::where('uid', Auth::id())->where('status', 1)->delete();
        return back()->with('success', __('messages.queue_cleared'));
    }
}
