<?php

namespace App\Http\Controllers\Dashboard\Sms;

use App\Http\Controllers\Controller;
use App\Models\Received;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReceivedController extends Controller
{
    public function index(Request $request)
    {
        $query = Received::where('uid', Auth::id());
        
        if ($request->search) {
            $query->where(function($q) use ($request) {
                $q->where('phone', 'like', "%{$request->search}%")
                  ->orWhere('message', 'like', "%{$request->search}%");
            });
        }
        
        $messages = $query->orderBy('receive_date', 'desc')->paginate(25);
        return view('dashboard.sms.received', compact('messages'));
    }

    public function destroy(Received $received)
    {
        $received->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
