<?php

namespace App\Http\Controllers\Dashboard\Sms;

use App\Http\Controllers\Controller;
use App\Models\Scheduled;
use App\Models\Device;
use App\Models\Group;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ScheduledController extends Controller
{
    public function index(Request $request)
    {
        $query = Scheduled::where('uid', Auth::id());
        
        if ($request->status) {
            $query->where('status', $request->status);
        }
        
        $scheduled = $query->orderBy('send_date', 'desc')->paginate(25);
        $devices = Device::where('uid', Auth::id())->get();
        $groups = Group::where('uid', Auth::id())->get();
        
        return view('dashboard.sms.scheduled', compact('scheduled', 'devices', 'groups'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'did' => 'required|string',
            'numbers' => 'required|string',
            'message' => 'required|string',
            'send_date' => 'required|date',
        ]);

        Scheduled::create([
            'uid' => Auth::id(),
            'did' => $request->did,
            'gateway' => $request->gateway ?? 1,
            'mode' => $request->mode ?? 1,
            'sim' => $request->sim ?? 0,
            'repeat_mode' => $request->repeat_mode ?? 0,
            'groups' => $request->groups ? implode(',', $request->groups) : null,
            'numbers' => $request->numbers,
            'message' => $request->message,
            'send_date' => $request->send_date,
            'status' => 1,
        ]);

        return back()->with('success', __('messages.scheduled_created'));
    }

    public function update(Request $request, Scheduled $scheduled)
    {
        $request->validate([
            'numbers' => 'required|string',
            'message' => 'required|string',
            'send_date' => 'required|date',
        ]);

        $scheduled->update($request->only(['did', 'numbers', 'message', 'send_date', 'repeat_mode']));
        return back()->with('success', __('messages.scheduled_updated'));
    }

    public function destroy(Scheduled $scheduled)
    {
        $scheduled->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
