<?php

namespace App\Http\Controllers\Dashboard\Sms;

use App\Http\Controllers\Controller;
use App\Models\Sent;
use App\Models\Device;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SentController extends Controller
{
    public function index(Request $request)
    {
        $query = Sent::where('uid', Auth::id());
        
        if ($request->search) {
            $query->where(function($q) use ($request) {
                $q->where('phone', 'like', "%{$request->search}%")
                  ->orWhere('message', 'like', "%{$request->search}%");
            });
        }
        
        if ($request->status) {
            $query->where('status', $request->status);
        }
        
        $messages = $query->orderBy('create_date', 'desc')->paginate(25);
        return view('dashboard.sms.sent', compact('messages'));
    }

    public function destroy(Sent $sent)
    {
        $sent->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
