<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Staff;
use Illuminate\Support\Facades\Hash;

class StaffController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $staff = Staff::where('uid', auth()->id())->get();
        return view('dashboard.tools.staff', compact('staff'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:staff',
            'password' => 'required|min:8|confirmed'
        ]);

        Staff::create([
            'uid' => auth()->id(),
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'permissions' => is_array($request->permissions) ? implode(',', $request->permissions) : ''
        ]);

        return redirect()->route('dashboard.tools.staff')->with('success', __('staff_created'));
    }

    public function update(Request $request, $id)
    {
        $staff = Staff::where('uid', auth()->id())->findOrFail($id);

        $data = [
            'name' => $request->name,
            'email' => $request->email,
            'permissions' => is_array($request->permissions) ? implode(',', $request->permissions) : ''
        ];

        if ($request->filled('password')) {
            $data['password'] = Hash::make($request->password);
        }

        $staff->update($data);

        return redirect()->route('dashboard.tools.staff')->with('success', __('staff_updated'));
    }

    public function destroy($id)
    {
        Staff::where('uid', auth()->id())->findOrFail($id)->delete();
        return redirect()->route('dashboard.tools.staff')->with('success', __('staff_deleted'));
    }
}
