<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Template;
use App\Models\TemplateCategory;

class TemplateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $templates = Template::where('uid', auth()->id())->with('category')->get();
        $categories = TemplateCategory::where('uid', auth()->id())->get();
        return view('dashboard.tools.templates', compact('templates', 'categories'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'content' => 'required|string'
        ]);

        Template::create([
            'uid' => auth()->id(),
            'name' => $request->name,
            'category_id' => $request->category_id,
            'content' => $request->content
        ]);

        return redirect()->route('dashboard.tools.templates')->with('success', __('template_created'));
    }

    public function update(Request $request, $id)
    {
        $template = Template::where('uid', auth()->id())->findOrFail($id);

        $template->update([
            'name' => $request->name,
            'category_id' => $request->category_id,
            'content' => $request->content
        ]);

        return redirect()->route('dashboard.tools.templates')->with('success', __('template_updated'));
    }

    public function destroy($id)
    {
        Template::where('uid', auth()->id())->findOrFail($id)->delete();
        return redirect()->route('dashboard.tools.templates')->with('success', __('template_deleted'));
    }
}
