<?php

namespace App\Http\Controllers\Dashboard\Tools;

use App\Http\Controllers\Controller;
use App\Models\Key;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class KeyController extends Controller
{
    public function index(Request $request)
    {
        $keys = Key::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.tools.keys', compact('keys'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'permissions' => 'nullable|array',
        ]);

        Key::create([
            'uid' => Auth::id(),
            'name' => $request->name,
            'secret' => Str::random(64),
            'permissions' => json_encode($request->permissions ?? []),
        ]);

        return back()->with('success', __('messages.key_created'));
    }

    public function update(Request $request, Key $key)
    {
        $request->validate(['name' => 'required|string|max:255']);
        $key->update([
            'name' => $request->name,
            'permissions' => json_encode($request->permissions ?? []),
        ]);
        return back()->with('success', __('messages.key_updated'));
    }

    public function regenerate(Key $key)
    {
        $key->update(['secret' => Str::random(64)]);
        return back()->with('success', __('messages.key_regenerated'));
    }

    public function destroy(Key $key)
    {
        $key->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
