<?php

namespace App\Http\Controllers\Dashboard\Tools;

use App\Http\Controllers\Controller;
use App\Models\Template;
use App\Models\TemplateCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TemplateController extends Controller
{
    public function index(Request $request)
    {
        $query = Template::where('uid', Auth::id());
        
        if ($request->category) {
            $query->where('category_id', $request->category);
        }
        
        $templates = $query->orderBy('id', 'desc')->paginate(25);
        $categories = TemplateCategory::where('uid', Auth::id())->get();
        
        return view('dashboard.tools.templates', compact('templates', 'categories'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'format' => 'required|string',
        ]);

        Template::create([
            'uid' => Auth::id(),
            'category_id' => $request->category_id ?? 0,
            'name' => $request->name,
            'format' => $request->format,
            'attachments' => $request->attachments,
        ]);

        return back()->with('success', __('messages.template_created'));
    }

    public function update(Request $request, Template $template)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'format' => 'required|string',
        ]);
        $template->update($request->only(['name', 'format', 'category_id', 'attachments']));
        return back()->with('success', __('messages.template_updated'));
    }

    public function destroy(Template $template)
    {
        $template->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
