<?php

namespace App\Http\Controllers\Dashboard\Tools;

use App\Http\Controllers\Controller;
use App\Models\Webhook;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class WebhookController extends Controller
{
    public function index(Request $request)
    {
        $webhooks = Webhook::where('uid', Auth::id())
            ->orderBy('create_date', 'desc')
            ->paginate(25);
            
        return view('dashboard.tools.webhooks', compact('webhooks'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'url' => 'required|url|max:500',
            'events' => 'nullable|array',
        ]);

        Webhook::create([
            'uid' => Auth::id(),
            'name' => $request->name,
            'url' => $request->url,
            'secret' => Str::random(32),
            'events' => json_encode($request->events ?? []),
        ]);

        return back()->with('success', __('messages.webhook_created'));
    }

    public function update(Request $request, Webhook $webhook)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'url' => 'required|url|max:500',
        ]);
        $webhook->update([
            'name' => $request->name,
            'url' => $request->url,
            'events' => json_encode($request->events ?? []),
        ]);
        return back()->with('success', __('messages.webhook_updated'));
    }

    public function destroy(Webhook $webhook)
    {
        $webhook->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
