<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Unsubscribed;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UnsubscribedController extends Controller
{
    public function index(Request $request)
    {
        $query = Unsubscribed::where('uid', Auth::id());
        
        if ($request->search) {
            $query->where('phone', 'like', "%{$request->search}%");
        }
        
        $unsubscribed = $query->orderBy('create_date', 'desc')->paginate(25);
        return view('dashboard.contacts.unsubscribed', compact('unsubscribed'));
    }

    public function store(Request $request)
    {
        $request->validate(['phone' => 'required|string|max:50']);
        Unsubscribed::create([
            'uid' => Auth::id(),
            'phone' => $request->phone,
            'type' => $request->type ?? 'sms',
        ]);
        return back()->with('success', __('messages.added'));
    }

    public function destroy(Unsubscribed $unsubscribed)
    {
        $unsubscribed->delete();
        return back()->with('success', __('messages.deleted'));
    }
}
