<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Page;

class PageController extends Controller
{
    public function show($id, $slug)
    {
        $page = Page::where('id', $id)->where('slug', $slug)->where('status', 1)->firstOrFail();

        // Check role access
        if (auth()->check()) {
            $userRole = auth()->user()->role;
            $allowedRoles = explode(',', $page->roles);

            if (!in_array('1', $allowedRoles) && !in_array($userRole, $allowedRoles)) {
                abort(403);
            }
        }

        $content = $page->content;

        return view('misc.page', compact('page', 'content'));
    }

    public function index()
    {
        $pages = Page::where('status', 1)->get();
        return view('misc.pages', compact('pages'));
    }
}
