<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class UnsubscribeController extends Controller
{
    public function show(Request $request)
    {
        $phone = $request->query('phone');
        $token = $request->query('token');

        if (!$phone || !$token) {
            abort(404);
        }

        // Verify token
        $expectedToken = hash('sha256', $phone . config('app.key'));
        if (!hash_equals($expectedToken, $token)) {
            abort(403);
        }

        return view('misc.unsubscribe', compact('phone', 'token'));
    }

    public function confirm(Request $request)
    {
        $request->validate([
            'phone' => 'required|string',
            'token' => 'required|string'
        ]);

        // Verify token
        $expectedToken = hash('sha256', $request->phone . config('app.key'));
        if (!hash_equals($expectedToken, $request->token)) {
            abort(403);
        }

        // Add to unsubscribed list
        \App\Models\Unsubscribed::firstOrCreate(
            ['phone' => $request->phone],
            ['created_at' => now()]
        );

        return view('misc.unsubscribe', ['success' => true]);
    }
}
