<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class WidgetController extends Controller
{
    public function qrCode($unique)
    {
        // Generate QR code for WhatsApp linking
        $qrData = [
            'unique' => $unique,
            'url' => config('app.url'),
            'token' => hash('sha256', $unique . config('app.key'))
        ];

        return response()->json($qrData);
    }

    public function embed(Request $request)
    {
        // Widget embed code generation
        $userId = $request->query('uid');
        $type = $request->query('type', 'chat');

        return view('widgets.embed', compact('userId', 'type'));
    }
}
