<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Action extends Model
{
    protected $table = 'actions';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'sid', 'type', 'source', 'event', 'priority', 'match',
        'ai_key', 'ai_plugins', 'group_trigger', 'sim', 'device', 'account',
        'link', 'name', 'keywords', 'message'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function getMessageDataAttribute(): array
    {
        return json_decode($this->message, true) ?? [];
    }
}
