<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AiPlugin extends Model
{
    protected $table = 'ai_plugins';
    public $timestamps = false;

    protected $fillable = ['uid', 'name', 'schema', 'endpoint'];

    protected $casts = [
        'schema' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
