<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Commission extends Model
{
    protected $table = 'commissions';
    public $timestamps = false;
    const CREATED_AT = 'create_date';

    protected $fillable = [
        'pid', 'sid', 'mid', 'did', 'original_amount', 
        'commission_amount', 'currency'
    ];

    protected $casts = [
        'create_date' => 'datetime',
    ];

    public function partner(): BelongsTo
    {
        return $this->belongsTo(User::class, 'pid', 'id');
    }

    public function seller(): BelongsTo
    {
        return $this->belongsTo(User::class, 'sid', 'id');
    }
}
