<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Deleted extends Model
{
    protected $table = 'deleted';
    public $timestamps = false;

    protected $fillable = ['uid', 'rid', 'did'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
