<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Device extends Model
{
    protected $table = 'devices';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'sid', 'did', 'name', 'manufacturer', 'version', 'global_device',
        'global_priority_device', 'shared', 'online_id', 'limit_status',
        'limit_interval', 'limit_value', 'random_send', 'random_min', 'random_max'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function sentMessages(): HasMany
    {
        return $this->hasMany(Sent::class, 'did', 'did');
    }

    public function receivedMessages(): HasMany
    {
        return $this->hasMany(Received::class, 'did', 'did');
    }
}
