<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Key extends Model
{
    protected $table = 'keys';
    public $timestamps = false;

    protected $fillable = ['uid', 'sid', 'name', 'secret', 'permissions'];

    protected $hidden = ['secret'];

    protected $casts = [
        'permissions' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
