<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Logger extends Model
{
    protected $table = 'logger';
    public $timestamps = false;

    protected $fillable = ['uid', 'ip', 'browser', 'os'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
