<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    protected $table = 'notifications';

    protected $fillable = [
        'uid', 'message', 'type', 'data', 'read', 'created_at'
    ];

    protected $casts = [
        'data' => 'array',
        'read' => 'boolean'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'uid');
    }
}
