<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Package extends Model
{
    protected $table = 'packages';
    public $timestamps = false;

    protected $fillable = [
        'name', 'permissions', 'price', 'send_limit', 'receive_limit',
        'ussd_limit', 'notification_limit', 'contact_limit', 'device_limit',
        'key_limit', 'webhook_limit', 'action_limit', 'scheduled_limit',
        'wa_account_limit', 'wa_send_limit', 'wa_receive_limit', 'wa_scheduled_limit',
        'partner_commission', 'hidden', 'footermark'
    ];

    protected $casts = [
        'permissions' => 'array',
        'price' => 'float',
    ];

    public function subscriptions(): HasMany
    {
        return $this->hasMany(Subscription::class, 'pid', 'id');
    }
}
