<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Quota extends Model
{
    protected $table = 'quota';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'sent', 'received', 'ussd', 'notifications',
        'wa_sent', 'wa_received', 'reset_date'
    ];

    protected $casts = [
        'reset_date' => 'date',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
