<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Received extends Model
{
    protected $table = 'received';
    public $timestamps = false;

    protected $fillable = ['uid', 'sid', 'did', 'sim', 'phone', 'message'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function device(): BelongsTo
    {
        return $this->belongsTo(Device::class, 'did', 'did');
    }
}
