<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ReportCache extends Model
{
    protected $table = 'reports_cache';
    public $timestamps = false;
    const CREATED_AT = 'create_date';

    protected $fillable = [
        'uid', 'report_date', 'sent', 'received', 'wa_sent', 'wa_received'
    ];

    protected $casts = [
        'report_date' => 'date',
        'create_date' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
