<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Scheduled extends Model
{
    protected $table = 'scheduled';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'sid', 'did', 'gateway', 'mode', 'sim', 'repeat_mode',
        'groups', 'numbers', 'message', 'send_date', 'status'
    ];

    protected $casts = [
        'send_date' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
