<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $table = 'settings';
    public $timestamps = false;

    protected $fillable = ['name', 'value'];

    public static function get(string $name, $default = null)
    {
        $setting = static::where('name', $name)->first();
        return $setting ? $setting->value : $default;
    }

    public static function set(string $name, $value): void
    {
        static::updateOrCreate(
            ['name' => $name],
            ['value' => is_array($value) ? json_encode($value) : $value]
        );
    }
}
