<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class StaffNotification extends Model
{
    protected $table = 'staff_notifications';
    public $timestamps = false;

    protected $fillable = ['sid', 'message', 'is_read'];

    public function staff(): BelongsTo
    {
        return $this->belongsTo(Staff::class, 'sid', 'id');
    }
}
