<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Subscription extends Model
{
    protected $table = 'subscriptions';
    public $timestamps = false;

    protected $fillable = ['uid', 'pid', 'tid', 'date'];

    protected $casts = [
        'date' => 'datetime',
    ];

    // Note: Using 'uid' not 'user_id', and 'pid' not 'package_id'
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function package(): BelongsTo
    {
        return $this->belongsTo(Package::class, 'pid', 'id');
    }

    public function transaction(): BelongsTo
    {
        return $this->belongsTo(Transaction::class, 'tid', 'id');
    }

    public function isActive(): bool
    {
        return $this->date >= now();
    }
}
