<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Transaction extends Model
{
    protected $table = 'transactions';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'pid', 'type', 'provider', 'ref', 'price', 'currency', 'duration'
    ];

    protected $casts = [
        'price' => 'float',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function package(): BelongsTo
    {
        return $this->belongsTo(Package::class, 'pid', 'id');
    }
}
