<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable;

    protected $table = 'users';
    public $timestamps = false;

    protected $fillable = [
        'role', 'email', 'password', 'credits', 'earnings', 'name', 'country',
        'language', 'theme_color', 'providers', 'alertsound', 'suspended',
        'timezone', 'formatting', 'partner', 'confirmed', 'avatar'
    ];

    protected $hidden = ['password'];

    protected $casts = [
        'formatting' => 'array',
        'providers' => 'array',
        'credits' => 'float',
        'earnings' => 'float',
    ];

    // Relationships - Note: using 'uid' as foreign key, not 'user_id'
    public function roleData(): BelongsTo
    {
        return $this->belongsTo(Role::class, 'role', 'id');
    }

    public function subscription(): HasOne
    {
        return $this->hasOne(Subscription::class, 'uid', 'id')
            ->latestOfMany();
    }

    public function subscriptions(): HasMany
    {
        return $this->hasMany(Subscription::class, 'uid', 'id');
    }

    public function devices(): HasMany
    {
        return $this->hasMany(Device::class, 'uid', 'id');
    }

    public function contacts(): HasMany
    {
        return $this->hasMany(Contact::class, 'uid', 'id');
    }

    public function groups(): HasMany
    {
        return $this->hasMany(Group::class, 'uid', 'id');
    }

    public function keys(): HasMany
    {
        return $this->hasMany(Key::class, 'uid', 'id');
    }

    public function webhooks(): HasMany
    {
        return $this->hasMany(Webhook::class, 'uid', 'id');
    }

    public function actions(): HasMany
    {
        return $this->hasMany(Action::class, 'uid', 'id');
    }

    public function templates(): HasMany
    {
        return $this->hasMany(Template::class, 'uid', 'id');
    }

    public function sentMessages(): HasMany
    {
        return $this->hasMany(Sent::class, 'uid', 'id');
    }

    public function receivedMessages(): HasMany
    {
        return $this->hasMany(Received::class, 'uid', 'id');
    }

    public function scheduledMessages(): HasMany
    {
        return $this->hasMany(Scheduled::class, 'uid', 'id');
    }

    public function waAccounts(): HasMany
    {
        return $this->hasMany(WaAccount::class, 'uid', 'id');
    }

    public function waSent(): HasMany
    {
        return $this->hasMany(WaSent::class, 'uid', 'id');
    }

    public function waReceived(): HasMany
    {
        return $this->hasMany(WaReceived::class, 'uid', 'id');
    }

    public function aiKeys(): HasMany
    {
        return $this->hasMany(AiKey::class, 'uid', 'id');
    }

    public function quota(): HasOne
    {
        return $this->hasOne(Quota::class, 'uid', 'id');
    }

    public function staff(): HasMany
    {
        return $this->hasMany(Staff::class, 'uid', 'id');
    }

    public function transactions(): HasMany
    {
        return $this->hasMany(Transaction::class, 'uid', 'id');
    }

    // Helper methods
    public function isAdmin(): bool
    {
        return $this->role === 1;
    }

    public function isSuspended(): bool
    {
        return $this->suspended === 1;
    }

    public function hasActiveSubscription(): bool
    {
        $subscription = $this->subscription;
        if (!$subscription) {
            return false;
        }
        return $subscription->date >= now();
    }
}
