<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class WaAccount extends Model
{
    protected $table = 'wa_accounts';
    public $timestamps = false;
    
    const CREATED_AT = 'create_date';

    protected $fillable = [
        'uid', 'name', 'wsid', 'wid', 'unique', 
        'receive_chats', 'random_send', 'random_min', 'random_max'
    ];

    protected $casts = [
        'create_date' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function server(): BelongsTo
    {
        return $this->belongsTo(WaServer::class, 'wsid', 'id');
    }

    public function sentMessages(): HasMany
    {
        return $this->hasMany(WaSent::class, 'unique', 'unique');
    }

    public function receivedMessages(): HasMany
    {
        return $this->hasMany(WaReceived::class, 'unique', 'unique');
    }

    public function groups(): HasMany
    {
        return $this->hasMany(WaGroup::class, 'wid', 'wid');
    }

    /**
     * التحقق من حالة الاتصال عبر Bridge
     */
    public function isConnected(): bool
    {
        if (!$this->server) {
            return false;
        }
        
        $wa = app(\App\Services\WhatsappBridgeService::class);
        $status = $wa->status(
            $this->server->secret,
            $this->server->url,
            $this->server->port,
            $this->unique
        );
        
        return $status === 'connected';
    }
}
