<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class WaCampaign extends Model
{
    protected $table = 'wa_campaigns';
    public $timestamps = false;

    protected $fillable = [
        'uid', 'sid', 'wid', 'unique', 'name', 'status', 'total', 'sent', 'failed'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(WaAccount::class, 'wid', 'wid');
    }

    public function messages(): HasMany
    {
        return $this->hasMany(WaSent::class, 'cid', 'id');
    }
}
