<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WaContactInfo extends Model
{
    protected $table = 'wa_contact_info';
    public $timestamps = false;
    const UPDATED_AT = 'updated_at';

    protected $fillable = ['uid', 'phone', 'wa_name', 'wa_profile_pic'];

    protected $casts = [
        'updated_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    /**
     * تحديث معلومات جهة الاتصال
     */
    public static function updateInfo(int $uid, string $phone, ?string $name = null, ?string $pic = null): void
    {
        self::updateOrCreate(
            ['uid' => $uid, 'phone' => $phone],
            array_filter([
                'wa_name' => $name,
                'wa_profile_pic' => $pic,
                'updated_at' => now(),
            ])
        );
    }
}
