<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WaGroup extends Model
{
    protected $table = 'wa_groups';
    public $timestamps = false;

    protected $fillable = ['uid', 'waid', 'jid', 'name', 'members'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(WaAccount::class, 'waid', 'id');
    }
}
