<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WaReceived extends Model
{
    protected $table = 'wa_received';
    public $timestamps = false;

    const CREATED_AT = 'receive_date';

    protected $fillable = [
        'uid', 'wid', 'unique', 'phone', 'group', 'message', 
        'is_read', 'read_at', 'read_by', 'first_responder_id',
        'message_id', 'quoted_message_id', 'quoted_text', 'quoted_sender',
        'wa_name', 'wa_profile_pic', 'group_name', 'group_profile_pic',
        'sender_name', 'media_url', 'is_deleted', 'is_edited'
    ];

    protected $casts = [
        'is_read' => 'boolean',
        'is_deleted' => 'boolean',
        'is_edited' => 'boolean',
        'receive_date' => 'datetime',
        'read_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(WaAccount::class, 'unique', 'unique');
    }

    public function isGroupMessage(): bool
    {
        return !empty($this->group);
    }

    public function markAsRead(int $readBy): void
    {
        if (!$this->is_read) {
            $this->update([
                'is_read' => true,
                'read_at' => now(),
                'read_by' => $readBy,
            ]);
        }
    }

    /**
     * تعيين المستجيب الأول
     */
    public function setFirstResponder(int $responderId): void
    {
        if (!$this->first_responder_id) {
            $this->update(['first_responder_id' => $responderId]);
        }
    }
}
