<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WaSent extends Model
{
    protected $table = 'wa_sent';
    public $timestamps = false;
    
    const CREATED_AT = 'create_date';

    protected $fillable = [
        'uid', 'sid', 'cid', 'wid', 'unique', 'phone', 'group', 
        'message', 'media_url', 'type', 'status', 'priority', 'api',
        'message_id', 'wa_name', 'wa_profile_pic', 'is_deleted', 'is_edited'
    ];

    protected $casts = [
        'is_deleted' => 'boolean',
        'is_edited' => 'boolean',
        'create_date' => 'datetime',
    ];

    // Message type constants
    const TYPE_TEXT = 'text';
    const TYPE_IMAGE = 'image';
    const TYPE_VIDEO = 'video';
    const TYPE_AUDIO = 'audio';
    const TYPE_DOCUMENT = 'document';
    const TYPE_LOCATION = 'location';
    const TYPE_CONTACT = 'contact';
    const TYPE_STICKER = 'sticker';

    // Status constants
    const STATUS_PENDING = 1;
    const STATUS_QUEUED = 2;
    const STATUS_SENT = 3;
    const STATUS_DELIVERED = 4;
    const STATUS_READ = 5;
    const STATUS_FAILED = 6;

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(WaAccount::class, 'unique', 'unique');
    }

    public function campaign(): BelongsTo
    {
        return $this->belongsTo(WaCampaign::class, 'cid', 'id');
    }
}
