<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Webhook extends Model
{
    protected $table = 'webhooks';
    public $timestamps = false;

    protected $fillable = ['uid', 'sid', 'name', 'url', 'secret', 'events'];

    protected $hidden = ['secret'];

    protected $casts = [
        'events' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'uid', 'id');
    }
}
