<?php

namespace App\Policies;

use App\Models\User;
use App\Models\WaAccount;
use Illuminate\Auth\Access\HandlesAuthorization;

class WaAccountPolicy
{
    use HandlesAuthorization;

    /**
     * Determine if the user can view the account.
     */
    public function view(User $user, WaAccount $account): bool
    {
        return $user->id === $account->uid || $user->isAdmin();
    }

    /**
     * Determine if the user can update the account.
     */
    public function update(User $user, WaAccount $account): bool
    {
        return $user->id === $account->uid || $user->isAdmin();
    }

    /**
     * Determine if the user can delete the account.
     */
    public function delete(User $user, WaAccount $account): bool
    {
        return $user->id === $account->uid || $user->isAdmin();
    }
}
