<?php

return [
    /*
    |--------------------------------------------------------------------------
    | WhatsApp Bridge Configuration
    |--------------------------------------------------------------------------
    |
    | إعدادات الاتصال بـ WhatsApp Bridge
    |
    */

    // معرف الموقع الفريد - يستخدم للتفريق بين المواقع المتعددة
    'site_unique' => env('WHATSAPP_SITE_UNIQUE', 'default'),

    // مهلة الاتصال بالثواني
    'timeout' => env('WHATSAPP_TIMEOUT', 30),
    
    'connect_timeout' => env('WHATSAPP_CONNECT_TIMEOUT', 10),

    // مسار حفظ ملفات الوسائط
    'media_path' => env('WHATSAPP_MEDIA_PATH', 'uploads/whatsapp'),

    // الحد الأقصى لحجم الملفات بالـ MB
    'max_file_size' => env('WHATSAPP_MAX_FILE_SIZE', 16),

    // أنواع الملفات المسموح بها
    'allowed_types' => [
        'image' => ['jpg', 'jpeg', 'png', 'gif', 'webp'],
        'video' => ['mp4', 'mkv', 'avi', '3gp'],
        'audio' => ['mp3', 'ogg', 'wav', 'm4a'],
        'document' => ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx', 'txt', 'zip'],
    ],

    // إعدادات S3 (اختياري)
    's3' => [
        'enabled' => env('WHATSAPP_S3_ENABLED', false),
        'bucket' => env('WHATSAPP_S3_BUCKET'),
        'region' => env('WHATSAPP_S3_REGION', 'us-east-1'),
        'key' => env('WHATSAPP_S3_KEY'),
        'secret' => env('WHATSAPP_S3_SECRET'),
    ],
];
