<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->unsignedBigInteger('pid');
            $table->dateTime('expiry_date');
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
            $table->index('pid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
