<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('devices', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('did', 255);
            $table->string('name', 255);
            $table->string('version', 50)->nullable();
            $table->string('manufacturer', 100)->nullable();
            $table->tinyInteger('random_send')->default(1);
            $table->integer('random_min')->default(1);
            $table->integer('random_max')->default(5);
            $table->tinyInteger('receive_sms')->default(1);
            $table->tinyInteger('global_device')->default(2);
            $table->text('global_slots')->nullable();
            $table->tinyInteger('global_priority')->default(2);
            $table->float('rate')->default(0);
            $table->string('fcm_token', 500)->nullable();
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
            $table->index('did');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('devices');
    }
};
