<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('campaigns', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('uid');
            $table->string('did', 255);
            $table->integer('gateway')->default(0);
            $table->tinyInteger('mode')->default(1);
            $table->tinyInteger('status')->default(1);
            $table->string('name', 255);
            $table->integer('contacts')->default(0);
            $table->timestamp('create_date')->useCurrent();
            
            $table->index('uid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('campaigns');
    }
};
